/*

Ringo Robot
Ringo_Virtual_Box_Demo_01
Version 1.0 7/2015

Ringo is trapped in a virtual circle. Uses acclerometer and gyro.


This sketch was written by Plum Geek LLC with 
significant portions written by Dustin Soodak.
This code is completely free for any use.
Visit http://www.plumgeek.com for Ringo information.
Visit http://www.arduino.cc to learn about the Arduino.

*/


#include "MiscHardware.h"
#include "Navigation.h"

void setup(){
  HardwareBegin();        //initialize Ringo's brain to work with his circuitry
  SwitchButtonToPixels();
  PlayStartChirp();       //Play startup chirp and blink eyes
  
  delay(1000);//make sure not moving robot when NavigationBegin() since it also zeroes the sensors
  //NavigationBegin();//initialize and start navigation
  RestartTimer();
  
}


int x,y,heading,i;
float box=150;   //was 80.
float dx,dy;
float xdist,ydist;//distance traveled until till the x (vertical) and y (horizontal) edges of box are hit
float edgedist,dist=0;


void loop(){ 
  SwitchPixelsToButton();SwitchMotorsToSerial();
  RestartTimer();  
  RxIRRestart();
  while(1){
    if(IsIRDone()){
      RxIRStop();
      for(i=0;i<IRNumOfBytes;i++){
        Serial.println(((unsigned char)IRBytes[i]),HEX);
      }
      if(IRBytes[2]==0x45 && IRBytes[3]==0xBA){//power//if(IRBytes[2]==0x44 && IRBytes[3]==0xBB)//test//
        IRBytes[2]=0;IRBytes[3]=0;break;
      }
      else{
        RxIRRestart();SwitchPixelsToButton();
      }       
    }//end if(IsIRDone())
    if(ButtonPressed()){
      delay(1000);break; 
    }
  }//end while(1) wait for robot or IR button
  ZeroNavigation();
  SwitchSerialToMotors();
  SwitchButtonToPixels();
  heading=0;x=0;y=0;
  while(1){
                
    randomSeed(millis());
    edgedist=0;
    while(edgedist<10 || edgedist==9999){
      heading=GetDegrees()+random(-180,180);
      //heading=((int)random(-4,4))*45;
      //heading=heading+((int)random(-4,4))*45;
      dy=sin(3.14159265359/2-((float)heading)*3.14159265359*2/360);
      dx=cos(3.14159265359/2-((float)heading)*3.14159265359*2/360);      
      //calculating how long till we hit x and y boundaries
      if(dx>.001)
        xdist=(box-x)/dx;// x+xdist*dx==box  (both xdist and ydist are distance in direction of motion (heading))
      else if(dx<-.001)
        xdist=(-box-x)/dx;
      else
        xdist=9999;
      if(dy>.001)
        ydist=(box-y)/dy;// y+ydist*dy==box  (both xdist and ydist are distance in direction of motion (heading))
      else if(dy<-.001)
        ydist=(-box-y)/dy;   
      else
        ydist=9999;
      //choose the shortest one so we don't go outside the box
      if(xdist>ydist)
        edgedist=ydist;
      else
        edgedist=xdist;
    }//end while(edgedist==0)    
    //SwitchPixelsToButton();
    //SwitchMotorsToSerial();
    //RestartTimer();
    //while(!ButtonPressed()){
    //  SimpleNavigation();
    //  if(GetTime()>500){
    //    Serial.print(" went ");Serial.print(dist);Serial.print(" to x ");Serial.print(x,DEC);Serial.print(" y ");Serial.print(y,DEC);Serial.print(" dir ");Serial.println(GetDegrees(),DEC);
    //    Serial.print(" dist ");Serial.print(xdist,DEC);Serial.print(" ");Serial.print(ydist,DEC);Serial.print(" ");Serial.print(edgedist,DEC);Serial.print("heading ");Serial.print(heading,DEC);
    //    Serial.print(" dx ");Serial.print(dx,DEC);Serial.print(" dy ");Serial.println(dy,DEC);
    //    
    //    RestartTimer();
    //  }
    //}
    //RestartTimer();
    //while(GetTime()<1000){
    //  SimpleNavigation();
    //}      
    RotateAccurate(heading,2000);
    dist=GetPositionY();
    MoveWithOptions(heading, 150, edgedist, 3000, 1000, 0, 5);  //speed was 150  //wiggle was 0
    dist=GetPositionY()-dist;      
    x=x+dist*dx; //note: GetPositionY() is relative to direction of robot
    y=y+dist*dy;
    SetAllPixelsRGB(0,0,0);RefreshPixels();    
    
  }    
}
